#include "vars.h"
#include "sounds.h"


void init_sound(void) {
   if (sfx_on == TRUE) {   
      if (install_sound(DIGI_AUTODETECT, MIDI_NONE, 0) != 0) {
         fprintf(fp, "Error initialising sound\n%s\n", allegro_error);
         install_sound (DIGI_NONE, MIDI_NONE, NULL);
         fprintf(fp, "Sounds deactivated!\n");
         sfx_on = FALSE;
      }
      else {
         fprintf(fp, "Digi Driver : %s\n", digi_driver->name);
         fprintf(fp, "Midi Driver : %s\n", midi_driver->name);
      }
      return;
   }
   else
      fprintf(fp, "Sounds deactivated!\n");
   return;
}

void play_sound(SAMPLE *sample, int posx){//fonction qui joue le son de coordonne 

   if (sfx_on == FALSE)
      return;

   //bon, ici, on va insirer la liste de sample  jouer!
  
   if (reverse_stereo == FALSE) {
      play_sample(sample, sfx_volume, (posx*255)/(SCREEN_W),  1000, FALSE);
   }
   else {
      play_sample(sample, sfx_volume, 255-(posx*255)/(SCREEN_W), 1000, FALSE);
   }
   
   return;
}